/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.util;

import com.ibm.hwmca.fw.servlet.jspemul.TLDManager;
import com.ibm.hwmca.fw.servlet.login.BobcatHmcPrincipal;
import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.servlet.util.StandalonePreferences;
import com.ibm.hwmca.fw.servlet.util.WCLUtil;
import com.ibm.hwmca.fw.servlet.util.impl.GuiLogHandler;
import com.ibm.hwmca.fw.servlet.util.impl.HMCTraceLogHandler;
import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.system.NullContextException;
import com.ibm.hwmca.fw.tomcat.HmcPrincipal;
import com.ibm.hwmca.fw.util.Trace;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

public class ServletRuntime {
    private static final String TRACE_MASKT = "XTIFSUTT";
    private static final String TRACE_MASKF = "XTIFSUTF";
    private static ServletRuntime runtime;
    private Logger logger;
    private StandalonePreferences servletOptions = new StandalonePreferences();
    private static boolean webApplicationInitialized;
    private String hmcContextPath;
    private static Pattern extractTimeZoneIdPattern;

    private ServletRuntime() {
    }

    public static Logger getLogger() {
        return ServletRuntime.getRuntime().getLoggerInstance();
    }

    private synchronized Logger getLoggerInstance() {
        if (this.logger == null) {
            this.logger = Logger.getAnonymousLogger();
            this.logger.setLevel(Level.ALL);
            this.logger.setUseParentHandlers(false);
            String logDestination = System.getProperty("hmc.servlet.log.destination");
            Handler handler = logDestination == null ? new HMCTraceLogHandler(this.logger) : (logDestination.equalsIgnoreCase("gui") ? new GuiLogHandler() : new HMCTraceLogHandler(this.logger));
            this.logger.addHandler(handler);
        }
        return this.logger;
    }

    public static synchronized ServletRuntime getRuntime() {
        if (runtime == null) {
            runtime = new ServletRuntime();
        }
        return runtime;
    }

    public synchronized Preferences getServletOptions() {
        return this.servletOptions;
    }

    public synchronized void setServletOptions(ServletContext servletContext) {
        Enumeration names = servletContext.getInitParameterNames();
        while (names.hasMoreElements()) {
            String parmName = (String)names.nextElement();
            this.servletOptions.put(parmName, servletContext.getInitParameter(parmName));
        }
    }

    public synchronized void setHMCContextPath(String contextPath) {
        this.hmcContextPath = contextPath;
    }

    public synchronized String getHMCContextPath() {
        if (this.hmcContextPath != null) {
            return this.hmcContextPath;
        }
        throw new IllegalStateException("The context path of the HMC web application is not set.");
    }

    public void attachUserContextToServletThread(HttpServletRequest req) throws ServletException {
        HMCSession hmcSession = HMCSession.getHMCSession(req.getSession());
        ClientUserContext userContext = hmcSession.getUserContext();
        if (userContext == null) {
            Principal principal = null;
            boolean runningBobcat = System.getProperty("RUNNING_BOBCAT", "false").equalsIgnoreCase("true");
            principal = runningBobcat ? (Principal)req.getSession().getAttribute("PRINCIPAL") : req.getUserPrincipal();
            if (principal instanceof HmcPrincipal) {
                HmcPrincipal hmcPrincipal = (HmcPrincipal)((Object)principal);
                userContext = new ClientUserContext(hmcPrincipal.getConnectionFactory());
                this.updateUserContext(userContext, req);
                Trace.trace(TRACE_MASKT, "Associating a user context with HMC session.  Client address is " + userContext.getAddress());
                hmcSession.setUserContext(userContext);
                userContext.setHMCSession(hmcSession);
            } else if (principal instanceof BobcatHmcPrincipal) {
                BobcatHmcPrincipal hmcPrincipal = (BobcatHmcPrincipal)principal;
                userContext = new ClientUserContext(hmcPrincipal.getConnectionFactory());
                this.updateUserContext(userContext, req);
                Trace.trace(TRACE_MASKT, "Associating a user context with HMC session.  Client address is " + userContext.getAddress());
                hmcSession.setUserContext(userContext);
                userContext.setHMCSession(hmcSession);
            } else {
                return;
            }
        }
        Trace.trace(TRACE_MASKF, "Associating a user context with HTTP Request.  HMC user name is \"" + userContext.getUserName() + '\"');
        userContext.attachToThread(true);
    }

    public void updateUserContext(ClientUserContext userContext, HttpServletRequest req) throws ServletException {
        boolean addressIsSet = false;
        try {
            String remoteHost = req.getRemoteHost();
            if (remoteHost != null) {
                userContext.setAddress(InetAddress.getByName(remoteHost));
                addressIsSet = true;
            }
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        if (!addressIsSet) {
            try {
                userContext.setAddress(InetAddress.getByName(req.getRemoteAddr()));
            }
            catch (UnknownHostException ee) {
                // empty catch block
            }
        }
        ArrayList<Locale> localesList = Collections.list(req.getLocales());
        Locale[] localeArray = new Locale[localesList.size()];
        localesList.toArray(localeArray);
        userContext.setLocales(localeArray);
        try {
            userContext.getConnectionFactory().updateUserContext(userContext);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "Exception updating UserContext:");
            Trace.trace(TRACE_MASKT, e);
        }
    }

    public TimeZone calculateTimeZone(String time, String timeString, String usesDST, String tzOffset) {
        TimeZone testZone;
        int i;
        if (timeString == null || usesDST == null || tzOffset == null) {
            return null;
        }
        Trace.trace(TRACE_MASKF, "Browser's Date.getTime() is: " + time);
        Trace.trace(TRACE_MASKF, "Browser's Date.toTimeString() sample is: " + timeString);
        Trace.trace(TRACE_MASKF, "Browser using daytime-saving-time is: " + usesDST);
        Trace.trace(TRACE_MASKF, "Browser's Date.getTimezoneOffset() is: " + tzOffset);
        long browserTime = 0L;
        int browserOffset = 0;
        try {
            browserTime = Long.parseLong(time);
        }
        catch (NumberFormatException e) {
            Trace.trace(TRACE_MASKT, "Error parsing browser's date long int");
            Trace.trace(TRACE_MASKT, e);
            return null;
        }
        try {
            browserOffset = Integer.parseInt(tzOffset);
        }
        catch (NumberFormatException e) {
            Trace.trace(TRACE_MASKT, "Error parsing browser's time zone offset");
            Trace.trace(TRACE_MASKT, e);
            return null;
        }
        browserOffset = -browserOffset * 60 * 1000;
        boolean browserUsesDST = usesDST.equals("true");
        String[] availableIds = TimeZone.getAvailableIDs();
        String id = null;
        Matcher extractTimeZoneIdMatcher = extractTimeZoneIdPattern.matcher(timeString);
        if (extractTimeZoneIdMatcher.find()) {
            id = extractTimeZoneIdMatcher.group(1);
            if (id == null) {
                id = extractTimeZoneIdMatcher.group(2);
            }
            TimeZone chosenZone = null;
            for (i = 0; i < availableIds.length && chosenZone == null; ++i) {
                if (!availableIds[i].equals(id) || (testZone = TimeZone.getTimeZone(availableIds[i])).getOffset(browserTime) != browserOffset || testZone.useDaylightTime() != browserUsesDST) continue;
                chosenZone = testZone;
            }
            if (chosenZone != null) {
                Trace.trace(TRACE_MASKT, "Found exact id match to known timezone with matching offset and DST flag to id " + chosenZone.getID());
                return chosenZone;
            }
        }
        ArrayList<TimeZone> candidates = new ArrayList<TimeZone>(5);
        for (i = 0; i < availableIds.length; ++i) {
            testZone = TimeZone.getTimeZone(availableIds[i]);
            if (testZone.getOffset(browserTime) != browserOffset || testZone.useDaylightTime() != browserUsesDST) continue;
            candidates.add(testZone);
        }
        if (candidates.size() == 1) {
            TimeZone chosenZone = (TimeZone)candidates.get(0);
            Trace.trace(TRACE_MASKT, "Found single known timezone with matching offset and DST flag.  Id is " + chosenZone.getID());
            return chosenZone;
        }
        if (!candidates.isEmpty()) {
            Trace.trace(TRACE_MASKF, "Found multiple known timezones with matching offset and DST flag:");
            Iterator iterator = candidates.iterator();
            while (iterator.hasNext()) {
                TimeZone zone = (TimeZone)iterator.next();
                Trace.trace(TRACE_MASKF, " id is " + zone.getID());
            }
            if (id != null) {
                try {
                    Locale userLocale = ClientUserContext.getUserContext().getLocale();
                    Iterator iterator2 = candidates.iterator();
                    while (iterator2.hasNext()) {
                        TimeZone zone = (TimeZone)iterator2.next();
                        if (!zone.getDisplayName(false, 1, userLocale).equalsIgnoreCase(id) && !zone.getDisplayName(true, 1, userLocale).equalsIgnoreCase(id) && !zone.getDisplayName(false, 0, userLocale).equalsIgnoreCase(id) && !zone.getDisplayName(true, 0, userLocale).equalsIgnoreCase(id)) continue;
                        Trace.trace(TRACE_MASKT, "Selecting timezone id \"" + zone.getID() + "\" because of display name match");
                        return zone;
                    }
                }
                catch (NullContextException e) {
                    Trace.trace(TRACE_MASKT, "Ignoring unexpected NullContextException interrogating user's locale");
                    Trace.trace(TRACE_MASKT, e);
                }
            }
            TimeZone zone = (TimeZone)candidates.get(0);
            Trace.trace(TRACE_MASKT, "No display name match.  Selecting first, with id \"" + zone.getID() + '\"');
            return zone;
        }
        StringBuffer customID = new StringBuffer();
        customID.append("GMT");
        customID.append(browserOffset < 0 ? (char)'-' : '+');
        int absBrowserOffsetInMinutes = Math.abs(browserOffset) / 1000 / 60;
        customID.append(absBrowserOffsetInMinutes / 60);
        customID.append(':');
        int minutes = absBrowserOffsetInMinutes % 60;
        if (minutes < 10) {
            customID.append('0');
        }
        customID.append(minutes);
        TimeZone zone = TimeZone.getTimeZone(customID.toString());
        Trace.trace(TRACE_MASKT, "Created custom time zone with id " + zone.getID());
        return zone;
    }

    public static synchronized void initializeWebApplication(HttpServletRequest req, ServletContext servletContext) {
        if (webApplicationInitialized) {
            return;
        }
        Trace.trace(TRACE_MASKF, "Initializing HMC web application");
        ServletRuntime.getRuntime().setHMCContextPath(req.getContextPath());
        runtime.setServletOptions(servletContext);
        WCLUtil.getWCLUtil().initializeInBackground(servletContext);
        TLDManager.initializeInBackground(servletContext);
        webApplicationInitialized = true;
    }

    static {
        extractTimeZoneIdPattern = Pattern.compile("\\((.*?)\\)$| (\\p{Alpha}*)$");
    }
}

